# XOOPS Publisher Custom Smarty Plugin
Eren Yumak aka B.Heyula!

A powerful and flexible Smarty3 plugin for XOOPS CMS that allows you to display Publisher module content anywhere in your theme with advanced filtering, sorting, and template options.

[![XOOPS](https://img.shields.io/badge/XOOPS-CMS-blue.svg)](https://xoops.org/)
[![PHP](https://img.shields.io/badge/PHP-7.0%2B-purple.svg)](https://www.php.net/)
[![License](https://img.shields.io/badge/License-GPL-green.svg)](https://www.gnu.org/licenses/gpl-3.0.html)

---

## 🌟 Features

- ✅ **Flexible Content Display** - Show Publisher content anywhere in your theme
- ✅ **Multiple Templates** - 4 pre-built professional templates included
- ✅ **Advanced Filtering** - Filter by category, status, tags, and more
- ✅ **Multiple Sorting Options** - Sort by date, title, views, rating, weight, or random
- ✅ **Pagination Support** - Built-in pagination with from/limit parameters
- ✅ **Cache System** - Optional caching for improved performance
- ✅ **Image Integration** - Full support for XOOPS image system
- ✅ **Debug Mode** - Comprehensive debugging for troubleshooting
- ✅ **Responsive Design** - All templates are mobile-friendly
- ✅ **Easy to Use** - Simple syntax, powerful results

---

## 📋 Table of Contents

- [Installation](#installation)
- [Quick Start](#quick-start)
- [Parameters](#parameters)
- [Templates](#templates)
- [Usage Examples](#usage-examples)
- [Template Variables](#template-variables)
- [Creating Custom Templates](#creating-custom-templates)
- [Advanced Usage](#advanced-usage)
- [Troubleshooting](#troubleshooting)
- [Performance Tips](#performance-tips)
- [FAQ](#faq)

---

## 🚀 Installation

### Prerequisites

- XOOPS CMS 2.5.x or higher
- Publisher module installed and active
- PHP 7.0 or higher
- Smarty3 template engine

### Step 1: Upload Plugin File

Upload `function.custom.php` to:
```
/class/smarty3_plugins/function.custom.php
```

Set file permissions to `644`

### Step 2: Upload Template Files

Upload template files to your theme directory:
```
/themes/[your_theme]/templates/publisher_custom.tpl
/themes/[your_theme]/templates/topgames.tpl
/themes/[your_theme]/templates/sidebar_widget.tpl
/themes/[your_theme]/templates/slider.tpl
```

### Step 3: Clear Cache

1. Go to XOOPS Admin Panel
2. Navigate to **System → Maintenance**
3. Click **Clear Cache**
4. Refresh your browser (Ctrl+F5)

### Step 4: Test

Add this code to your theme:
```smarty
<{custom limit="5" status="2"}>
```

If content appears, installation is successful! 🎉

---

## ⚡ Quick Start

### Basic Usage

Display 5 latest items:
```smarty
<{custom limit="5" status="2"}>
```

### With Category Filter

Show items from category 2:
```smarty
<{custom category="2" limit="10" status="2"}>
```

### With Custom Template

Use the games grid template:
```smarty
<{custom category="2" template="topgames" limit="20" status="2"}>
```

### Most Popular Items

Sort by view count:
```smarty
<{custom order="counter" sort="DESC" limit="10" status="2"}>
```

---

## 📖 Parameters

### Complete Parameter Reference

| Parameter | Type | Default | Description | Example |
|-----------|------|---------|-------------|---------|
| **category** | integer | 0 | Category ID (0 = all categories) | `category="2"` |
| **template** | string | publisher_custom | Template file to use | `template="topgames"` |
| **available** | string | - | Content tag filter | `available="spotlight"` |
| **from** | integer | 0 | Starting offset for pagination | `from="10"` |
| **limit** | integer | 10 | Number of items to display | `limit="20"` |
| **cache** | string | no | Enable caching (yes/no) | `cache="yes"` |
| **order** | string | date | Sort field | `order="rating"` |
| **sort** | string | DESC | Sort direction (ASC/DESC) | `sort="ASC"` |
| **status** | integer | 1 | Content status filter | `status="2"` |
| **debug** | boolean | - | Enable debug mode | `debug="1"` |

### Parameter Details

#### category

Filter items by category ID.

**Values:**
- `0` - All categories (default)
- `1,2,3...` - Specific category ID

**Examples:**
```smarty
<{* All categories *}>
<{custom category="0" limit="10"}>

<{* Only category 2 *}>
<{custom category="2" limit="20"}>

<{* Games category *}>
<{custom category="5" limit="15"}>
```

#### template

Specify which template file to use for display.

**Available Templates:**
- `publisher_custom` - Standard list view (default)
- `topgames` - Grid layout for games/content cards
- `sidebar_widget` - Compact sidebar widget
- `slider` - Full-width carousel slider

**Examples:**
```smarty
<{custom template="publisher_custom" limit="10"}>
<{custom template="topgames" limit="20"}>
<{custom template="sidebar_widget" limit="5"}>
<{custom template="slider" limit="5"}>
```

#### available

Filter by content tags (requires Publisher tags to be set).

**Values:**
- `main` - Items tagged for main page
- `spotlight` - Featured/highlighted items
- `recent` - Recently added items

**Examples:**
```smarty
<{* Main page items *}>
<{custom available="main" limit="10"}>

<{* Featured content *}>
<{custom available="spotlight" limit="5"}>
```

#### order

Sort items by specific field.

**Values:**
- `date` - Publication date (default)
- `title` - Alphabetical by title
- `counter` - View count (popularity)
- `rating` - User rating/score
- `weight` - Manual ordering weight
- `random` - Random order

**Examples:**
```smarty
<{* Latest items *}>
<{custom order="date" sort="DESC"}>

<{* Most popular *}>
<{custom order="counter" sort="DESC"}>

<{* Highest rated *}>
<{custom order="rating" sort="DESC"}>

<{* Alphabetical *}>
<{custom order="title" sort="ASC"}>

<{* Random selection *}>
<{custom order="random" limit="5"}>
```

#### status

Filter by publication status.

**Values:**
- `0` - All statuses
- `1` - Published (live)
- `2` - Offline/Draft
- `3` - Pending approval
- `4` - Rejected

**Examples:**
```smarty
<{* Only published items *}>
<{custom status="1" limit="10"}>

<{* Draft items (admin preview) *}>
<{custom status="2" limit="10"}>

<{* All items regardless of status *}>
<{custom status="0" limit="10"}>
```

#### from & limit (Pagination)

Control pagination and result sets.

**Examples:**
```smarty
<{* Page 1: Items 1-10 *}>
<{custom from="0" limit="10"}>

<{* Page 2: Items 11-20 *}>
<{custom from="10" limit="10"}>

<{* Page 3: Items 21-30 *}>
<{custom from="20" limit="10"}>

<{* Show 50 items *}>
<{custom from="0" limit="50"}>
```

#### cache

Enable or disable result caching.

**Values:**
- `yes` - Enable caching (1 hour)
- `no` - Disable caching (default)

**Examples:**
```smarty
<{* Cache for performance *}>
<{custom limit="10" cache="yes"}>

<{* Always fresh data *}>
<{custom limit="10" cache="no"}>
```

**When to use cache:**
- ✅ Sidebar widgets
- ✅ Footer content
- ✅ Popular items list
- ❌ Main slider (needs to be current)
- ❌ "Latest" sections

#### debug

Enable debug mode for troubleshooting.

**Usage:**
```smarty
<{custom limit="5" debug="1"}>
```

**Debug Output** (in HTML source - Ctrl+U):
```html
<!-- DEBUG MODE AKTIF -->
<!-- Parametreler: category=0, limit=5, order=date, status=2 -->
<!-- Tablo prefix: xaf9 -->
<!-- SQL: SELECT * FROM xaf9_publisher_items WHERE status = 2 ORDER BY datesub DESC LIMIT 0, 5 -->
<!-- Bulunan kayıt sayısı: 5 -->
<!-- Resim ID: 1, Dosya adı: img123.jpg -->
<!-- Resim URL: https://site.com/uploads/images/img123.jpg -->
```

---

## 🎨 Templates

### 1. publisher_custom.tpl

**Standard list view with detailed information.**

**Features:**
- Full-width list layout
- Images with thumbnails
- Title, subtitle, summary
- Author info, date, view count
- Rating display
- Read more links

**Usage:**
```smarty
<{custom template="publisher_custom" limit="10" status="2"}>
```

**Best For:**
- Blog posts
- News articles
- Detailed content lists
- Main content areas

---

### 2. topgames.tpl

**Modern grid layout for games or content cards.**

**Features:**
- Responsive grid (auto-adjusts columns)
- Card-based design
- Hover effects
- Star rating system
- View counter
- Play/action buttons

**Usage:**
```smarty
<{custom category="2" template="topgames" limit="20" status="2"}>
```

**Best For:**
- Games catalog
- Product listings
- Portfolio items
- Media galleries

---

### 3. sidebar_widget.tpl

**Compact widget for sidebars.**

**Features:**
- Minimal design
- Small thumbnails (80x80px)
- Title truncation
- Compact meta info
- Perfect for tight spaces

**Usage:**
```smarty
<{custom template="sidebar_widget" limit="5" status="2"}>
```

**Best For:**
- Sidebar widgets
- Footer sections
- "You might like" boxes
- Related content

---

### 4. slider.tpl

**Full-width carousel slider with auto-play.**

**Features:**
- Full-screen slider
- Auto-rotation (5 seconds)
- Navigation arrows
- Dot indicators
- Overlay effects
- Gradient backgrounds

**Usage:**
```smarty
<{custom template="slider" available="spotlight" limit="5" status="2"}>
```

**Best For:**
- Homepage hero section
- Featured content
- Promotional banners
- Top announcements

---

## 💡 Usage Examples

### Example 1: Homepage Hero Slider

```smarty
<section class="hero-section">
    <{custom 
        template="slider" 
        available="spotlight" 
        limit="5" 
        order="weight" 
        status="2"
    }>
</section>
```

### Example 2: Popular Games Grid

```smarty
<section class="popular-games">
    <h2>Most Popular Games</h2>
    <{custom 
        category="2" 
        template="topgames" 
        limit="12" 
        order="counter" 
        sort="DESC" 
        status="2" 
        cache="yes"
    }>
</section>
```

### Example 3: Sidebar - Top Rated

```smarty
<aside class="sidebar">
    <div class="widget">
        <h3>Top Rated</h3>
        <{custom 
            template="sidebar_widget" 
            limit="5" 
            order="rating" 
            sort="DESC" 
            status="2" 
            cache="yes"
        }>
    </div>
</aside>
```

### Example 4: Latest News

```smarty
<section class="latest-news">
    <h2>Latest News</h2>
    <{custom 
        category="5" 
        template="publisher_custom" 
        limit="10" 
        order="date" 
        sort="DESC" 
        status="2"
    }>
</section>
```

### Example 5: Random Content Discovery

```smarty
<section class="discover">
    <h2>🎲 Discover Something New</h2>
    <p>Random selection just for you!</p>
    <{custom 
        order="random" 
        template="topgames" 
        limit="8" 
        status="2" 
        cache="no"
    }>
    <a href="?" class="btn-refresh">Show More</a>
</section>
```

### Example 6: Category Page with Pagination

**Page 1:**
```smarty
<{custom 
    category="3" 
    template="topgames" 
    from="0" 
    limit="20" 
    order="date" 
    status="2"
}>
```

**Page 2:**
```smarty
<{custom 
    category="3" 
    template="topgames" 
    from="20" 
    limit="20" 
    order="date" 
    status="2"
}>
```

### Example 7: Multi-Section Homepage

```smarty
<!DOCTYPE html>
<html>
<body>
    <!-- Hero Slider -->
    <section class="hero">
        <{custom template="slider" available="spotlight" limit="5" status="2"}>
    </section>
    
    <!-- Featured Games -->
    <section class="featured">
        <h2>Featured Games</h2>
        <{custom category="2" template="topgames" limit="8" order="rating" status="2"}>
    </section>
    
    <!-- Latest News -->
    <section class="news">
        <h2>Latest News</h2>
        <{custom category="5" template="publisher_custom" limit="5" order="date" status="2"}>
    </section>
    
    <!-- Sidebar -->
    <aside class="sidebar">
        <h3>Popular This Week</h3>
        <{custom template="sidebar_widget" limit="5" order="counter" status="2"}>
        
        <h3>You Might Like</h3>
        <{custom template="sidebar_widget" limit="5" order="random" status="2" cache="no"}>
    </aside>
</body>
</html>
```

### Example 8: Alphabetical Index

```smarty
<section class="alphabetical-index">
    <h2>All Games (A-Z)</h2>
    <{custom 
        category="2" 
        template="publisher_custom" 
        limit="100" 
        order="title" 
        sort="ASC" 
        status="2"
    }>
</section>
```

### Example 9: Editor's Choice

```smarty
<section class="editors-choice">
    <h2>⭐ Editor's Choice</h2>
    <{custom 
        available="main" 
        template="topgames" 
        limit="6" 
        order="weight" 
        sort="ASC" 
        status="2"
    }>
</section>
```

### Example 10: "Try Your Luck" Button

```smarty
<div class="lucky-pick">
    <h2>Feeling Lucky? 🎲</h2>
    <p>We'll pick something random for you!</p>
    <{custom 
        order="random" 
        template="topgames" 
        limit="1" 
        status="2" 
        cache="no"
    }>
    <a href="?" class="btn-try-again">Try Again</a>
</div>
```

---

## 📊 Template Variables

All templates have access to these variables:

### Global Variables

```smarty
<{$publisher_count}>  {* Total number of items *}
<{$publisher_items}>  {* Array of items *}
```

### Item Variables

Inside the foreach loop:

```smarty
<{foreach item=item from=$publisher_items}>
    
    {* Basic Info *}
    <{$item.itemid}>              {* Item ID *}
    <{$item.title}>               {* Title *}
    <{$item.subtitle}>            {* Subtitle *}
    <{$item.summary}>             {* Summary/Excerpt *}
    <{$item.body}>                {* Full content *}
    
    {* Images *}
    <{$item.image}>               {* Full-size image URL *}
    <{$item.thumb}>               {* Thumbnail image URL *}
    
    {* Links *}
    <{$item.link}>                {* Item detail page URL *}
    <{$item.category_link}>       {* Category page URL *}
    
    {* Category *}
    <{$item.categoryid}>          {* Category ID *}
    
    {* Author *}
    <{$item.author_name}>         {* Author username *}
    <{$item.author_link}>         {* Author profile URL *}
    
    {* Dates *}
    <{$item.date}>                {* Long date format *}
    <{$item.date_short}>          {* Short date format *}
    <{$item.datesub}>             {* Unix timestamp *}
    
    {* Statistics *}
    <{$item.counter}>             {* View count *}
    <{$item.rating}>              {* Rating (0-5) *}
    <{$item.votes}>               {* Number of votes *}
    <{$item.rating_percent}>      {* Rating percentage (0-100) *}
    
    {* Ordering *}
    <{$item.weight}>              {* Manual order weight *}
    
<{/foreach}>
```

---

## 🎨 Creating Custom Templates

### Basic Template Structure

Create a new file: `/themes/[your_theme]/templates/my_template.tpl`

```smarty
<{* Check if items exist *}>
<{if $publisher_count > 0}>
    
    <div class="my-custom-layout">
        <{foreach item=item from=$publisher_items}>
            
            <div class="item">
                <{* Image *}>
                <{if $item.image}>
                    <img src="<{$item.thumb}>" alt="<{$item.title}>">
                <{/if}>
                
                <{* Title *}>
                <h3><a href="<{$item.link}>"><{$item.title}></a></h3>
                
                <{* Summary *}>
                <{if $item.summary}>
                    <p><{$item.summary}></p>
                <{/if}>
                
                <{* Meta info *}>
                <div class="meta">
                    <span><{$item.date_short}></span>
                    <span><{$item.counter}> views</span>
                </div>
            </div>
            
        <{/foreach}>
    </div>
    
<{else}>
    <p>No items found.</p>
<{/if}>
```

### Advanced Template Example

```smarty
<{if $publisher_count > 0}>
    <div class="advanced-grid">
        <{foreach item=item from=$publisher_items}>
            
            <article class="grid-item">
                <{* Featured image *}>
                <{if $item.image}>
                    <div class="item-image">
                        <a href="<{$item.link}>">
                            <img src="<{$item.image}>" alt="<{$item.title}>">
                        </a>
                        <{* Badge for high-rated items *}>
                        <{if $item.rating >= 4.5}>
                            <span class="badge-top">⭐ Top Rated</span>
                        <{/if}>
                    </div>
                <{/if}>
                
                <div class="item-content">
                    <{* Title *}>
                    <h3><a href="<{$item.link}>"><{$item.title}></a></h3>
                    
                    <{* Rating stars *}>
                    <{if $item.votes > 0}>
                        <div class="rating">
                            <{assign var="stars" value=$item.rating|floor}>
                            <{section name=star loop=5}>
                                <{if $smarty.section.star.index < $stars}>
                                    <span class="star filled">★</span>
                                <{else}>
                                    <span class="star">☆</span>
                                <{/if}>
                            <{/section}>
                            <span class="rating-text">
                                <{$item.rating}>/5 (<{$item.votes}> votes)
                            </span>
                        </div>
                    <{/if}>
                    
                    <{* Truncated summary *}>
                    <{if $item.summary}>
                        <p><{$item.summary|truncate:150:"..."}></p>
                    <{/if}>
                    
                    <{* Meta information *}>
                    <div class="item-meta">
                        <span class="author">
                            By <a href="<{$item.author_link}>"><{$item.author_name}></a>
                        </span>
                        <span class="date"><{$item.date_short}></span>
                        <span class="views">👁 <{$item.counter}></span>
                    </div>
                    
                    <{* Action button *}>
                    <a href="<{$item.link}>" class="btn-read-more">
                        Read More →
                    </a>
                </div>
            </article>
            
        <{/foreach}>
    </div>
<{else}>
    <div class="no-items">
        <p>No content available at this time.</p>
    </div>
<{/if}>

<style>
.advanced-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 30px;
}

.grid-item {
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.grid-item:hover {
    transform: translateY(-5px);
}

.item-image {
    position: relative;
}

.item-image img {
    width: 100%;
    height: 200px;
    object-fit: cover;
}

.badge-top {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #ffd700;
    color: #000;
    padding: 5px 10px;
    border-radius: 5px;
    font-weight: bold;
    font-size: 12px;
}

.item-content {
    padding: 20px;
}

.rating {
    margin: 10px 0;
}

.star {
    color: #ddd;
    font-size: 18px;
}

.star.filled {
    color: #ffd700;
}

.item-meta {
    margin: 15px 0;
    font-size: 14px;
    color: #666;
}

.item-meta span {
    margin-right: 15px;
}

.btn-read-more {
    display: inline-block;
    padding: 10px 20px;
    background: #0066cc;
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
}

.btn-read-more:hover {
    background: #0052a3;
}
</style>
```

### Usage of Custom Template

```smarty
<{custom template="my_template" limit="12" status="2"}>
```

---

## 🚀 Advanced Usage

### Combining Multiple Filters

```smarty
<{* High-rated games from category 2 *}>
<{custom 
    category="2" 
    order="rating" 
    sort="DESC" 
    limit="10" 
    status="2"
}>
```

### Dynamic Pagination

```smarty
<{assign var="page" value=$smarty.get.page|default:1}>
<{assign var="offset" value=($page-1)*20}>

<{custom 
    category="3" 
    from=$offset 
    limit="20" 
    status="2"
}>

<{* Pagination links *}>
<div class="pagination">
    <{if $page > 1}>
        <a href="?page=<{$page-1}>">← Previous</a>
    <{/if}>
    <a href="?page=<{$page+1}>">Next →</a>
</div>
```

### Conditional Display

```smarty
<{* Show popular games if available, otherwise show latest *}>
<{assign var="popular_count" value=0}>

<{custom 
    order="counter" 
    sort="DESC" 
    limit="5" 
    status="2" 
    assign="popular_items"
}>

<{if $publisher_count > 0}>
    <h2>Popular Games</h2>
    <{* Display popular items *}>
<{else}>
    <h2>Latest Games</h2>
    <{custom order="date" limit="5" status="2"}>
<{/if}>
```

### Multiple Sections

```smarty
<!-- Section 1: Featured -->
<section class="featured">
    <h2>Featured Content</h2>
    <{custom available="spotlight" template="slider" limit="5" status="2"}>
</section>

<!-- Section 2: Most Popular -->
<section class="popular">
    <h2>Most Popular</h2>
    <{custom order="counter" template="topgames" limit="12" status="2"}>
</section>

<!-- Section 3: Latest -->
<section class="latest">
    <h2>Just Added</h2>
    <{custom order="date" template="publisher_custom" limit="10" status="2"}>
</section>

<!-- Section 4: Random Discovery -->
<section class="discover">
    <h2>Discover</h2>
    <{custom order="random" template="topgames" limit="8" status="2" cache="no"}>
</section>
```

---

## 🐛 Troubleshooting

### Issue: Plugin Not Working

**Symptoms:** Code appears as text on page

**Solutions:**
1. Check plugin file location:
   ```
   /class/smarty3_plugins/function.custom.php
   ```
2. Clear cache:
   ```
   Admin → System → Maintenance → Clear Cache
   ```
3. Check file permissions: `644`
4. Refresh browser: `Ctrl+F5`

### Issue: No Content Displayed

**Symptoms:** "No items found" or empty section

**Solutions:**

1. **Enable debug mode:**
   ```smarty
   <{custom limit="10" debug="1"}>
   ```

2. **Check SQL in HTML source** (Ctrl+U):
   ```html
   <!-- Bulunan kayıt sayısı: 0 -->
   ```

3. **Verify status value:**
   - Check phpMyAdmin: What status values exist?
   - Try different status: `status="0"` (all)

4. **Check category:**
   ```sql
   SELECT categoryid, COUNT(*) FROM xaf9_publisher_items 
   WHERE status = 2 GROUP BY categoryid;
   ```

### Issue: Images Not Loading

**Symptoms:** Broken image icons or wrong paths

**Solutions:**

1. **Check debug output:**
   ```html
   <!-- Resim URL: https://site.com/uploads/images/... -->
   ```

2. **Verify image table:**
   ```sql
   SELECT * FROM xaf9_image LIMIT 5;
   ```

3. **Check file paths:**
   - Images should be in: `/uploads/images/`
   - Thumbnails: `/uploads/images/thumbs/`

### Issue: Template Not Found

**Symptoms:** Orange error message

**Solutions:**

1. Check template file exists:
   ```
   /themes/[your_theme]/templates/publisher_custom.tpl
   ```

2. Check filename matches (case-sensitive)

3. Use debug to see searched paths:
   ```html
   <!-- Template aranan yerler: ... -->
   ```

### Issue: Wrong Items Displayed

**Symptoms:** Items from wrong category

**Solutions:**

1. **Verify with debug:**
   ```smarty
   <{custom category="5" debug="1"}>
   ```

2. **Check SQL output:**
   ```html
   <!-- SQL: ... AND categoryid = 5 ... -->
   ```

3. **Test in phpMyAdmin:**
   ```sql
   SELECT itemid, title, categoryid FROM xaf9_publisher_items 
   WHERE categoryid = 5 AND status = 2;
   ```

### Issue: Cache Problems

**Symptoms:** Old content showing

**Solutions:**

1. Disable cache:
   ```smarty
   <{custom cache="no" limit="10"}>
   ```

2. Clear cache directory:
   ```
   /var/caches/smarty_cache/
   ```

3. Clear browser cache: `Ctrl+Shift+Delete`

---

## ⚡ Performance Tips

### 1. Use Cache Wisely

**✅ DO use cache for:**
- Sidebar widgets
- Footer content
- Popular items
- Static sections

**❌ DON'T use cache for:**
- Main sliders
- "Latest" sections
- Random content
- Frequently updated content

```smarty
<{* Good - static sidebar *}>
<{custom template="sidebar_widget" limit="5" cache="yes"}>

<{* Good - dynamic main content *}>
<{custom order="date" limit="10" cache="no"}>
```

### 2. Limit Result Sets

**✅ Good:**
```smarty
<{custom limit="5"}>  {* Fast *}
<{custom limit="20"}> {* Good *}
```

**❌ Avoid:**
```smarty
<{custom limit="500"}> {* Slow *}
```

### 3. Use Category Filters

**✅ Faster:**
```smarty
<{custom category="2" limit="20"}>
```

**❌ Slower:**
```smarty
<{custom category="0" limit="20"}>
```

### 4. Optimize Random Queries

Random queries are slower. Limit results:

**✅ Good:**
```smarty
<{custom order="random" limit="5"}>
```

**❌ Slow:**
```smarty
<{custom order="random" limit="100"}>
```

### 5. Database Indexes

Ensure these columns are indexed:
- `status`
- `categoryid`
- `datesub`
- `counter`
- `rating`

---

## ❓ FAQ

### Q: Can I use multiple custom blocks on one page?

**A:** Yes! You can use as many as you need:

```smarty
<{custom category="1" limit="5"}>
<{custom category="2" limit="10"}>
<{custom category="3" template="topgames" limit="20"}>
```

### Q: How do I create my own template?

**A:** Create a `.tpl` file in `/themes/[theme]/templates/` and use the template variables. See [Creating Custom Templates](#creating-custom-templates).

### Q: Can I show content from multiple categories?

**A:** Currently, the plugin supports one category per call. Use multiple calls:

```smarty
<{custom category="1" limit="5"}>
<{custom category="2" limit="5"}>
```

### Q: How do I show only published content?

**A:** Use `status="1"`:

```smarty
<{custom status="1" limit="10"}>
```

### Q: What's the difference between cache="yes" and cache="no"?

**A:** 
- `cache="yes"` - Stores results for 1 hour (faster)
- `cache="no"` - Always fetches fresh data (slower, but current)

### Q: Can I customize the cache duration?

**A:** Yes, edit `function.custom.php` and change:

```php
if ((time() - $cache_time) < 3600) // 3600 = 1 hour
```

### Q: How do I show items from all categories?

**A:** Use `category="0"`:

```smarty
<{custom category="0" limit="20"}>
```

### Q: Can I exclude certain categories?

**A:** Not directly. You need to modify the SQL in `function.custom.php` or call specific categories.

### Q: How do I implement search functionality?

**A:** The plugin doesn't include search. Use Publisher's built-in search feature.

### Q: Can I use this with other XOOPS modules?

**A:** No, this plugin is specifically designed for the Publisher module.

### Q: How do I update the plugin?

**A:**
1. Backup current `function.custom.php`
2. Upload new version
3. Clear cache
4. Test your site

### Q: Is this compatible with XOOPS 2.5.11?

**A:** Yes, it works with XOOPS 2.5.x and newer versions with Smarty3.

---

## 📝 Changelog

### Version 2.7 (Latest)
- ✅ Fixed image path handling for xaf9_image table
- ✅ Removed duplicate "images/" in URLs
- ✅ Added support for image thumbnails
- ✅ Improved debug output

### Version 2.6
- ✅ Added xaf9_image table integration
- ✅ Support for XOOPS image management system
- ✅ Enhanced image URL generation

### Version 2.5
- ✅ Fixed image paths to use /uploads/images/
- ✅ Added automatic image extension detection

### Version 2.4
- ✅ Added automatic file extension detection (.jpg, .png, .gif, .webp)

### Version 2.3
- ✅ Added random sorting option (`order="random"`)

### Version 2.2
- ✅ Fixed Smarty template_dir issue
- ✅ Improved template loading

### Version 2.1
- ✅ Removed table existence check (caused issues)
- ✅ Improved error messages

### Version 2.0
- ✅ Added debug mode
- ✅ Enhanced error handling
- ✅ Support for different Publisher versions

### Version 1.0
- 🎉 Initial release

---

## 🤝 Contributing

Contributions are welcome! If you find a bug or want to add a feature:

1. Fork the repository
2. Create your feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

---

## 📄 License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.

---

## 👤 Author

Created for XOOPS CMS community B.Heyula

---

## 🙏 Acknowledgments

- XOOPS Development Team
- Publisher Module Developers
- XOOPS Community

---

## 📞 Support

For issues and questions:

1. Check the [Troubleshooting](#troubleshooting) section
2. Enable [debug mode](#debug)
3. Visit [XOOPS Forums](https://xoops.org/modules/newbb/)
4. Check [Publisher Module Documentation](https://github.com/XoopsModules25x/publisher)

---

## 🔗 Useful Links

- [XOOPS Official Site](https://xoops.org/)
- [Publisher Module](https://github.com/XoopsModules25x/publisher)
- [XOOPS Documentation](https://xoops.gitbook.io/)
- [Smarty Documentation](https://www.smarty.net/docs/en/)

---

**Happy Coding! 🚀**

*If this plugin helped you, please consider starring the repository and sharing with others!*
